//
//  MCSurveyor.h
//  MCApplication
//
//  Created by mclark on Wed Jul 18 2001.
//  Copyright (c) 2001 __CompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface MCSurveyor : NSObject {
@private
    NSArray                *searchFiles; // config files to look for
    NSMutableDictionary    *loadedPluginRegistry;
    NSMutableDictionary    *loadablePlugins;// = nil; // Both Frameworks and Bundles
    NSMutableString        *classPath;// = nil; // The resulting classpath from loading the modules
    NSString               *frameworkSearchPath;// = nil;
    NSString               *bundleSearchPath;// = nil;
    int                     progressPanelIntervals;
}

+ (MCSurveyor *)defaultInstance;
- (void)survey;
- (void)surveyAtPath: (NSString *)path forType: (NSString *)type;
- (void)surveyFrameworks;
- (void)surveyBundles;
- (void)loadFoundPlugins;

// *** ACCESSOR METHODS ***
- (NSArray *)menuConfigs;
- (NSArray *)javaConfigs;
- (NSArray *)toolbars;
- (NSArray *)eomodelConfigs;
- (NSArray *)inspectorConfigs;
- (NSArray *)toolbarItemConfigs;
@end
